<?php
error_reporting(1);
?>
<!DOCTYPE html>
<html lang="en">
	<head>
		<title>three.js webgl - FBX loader</title>
		<meta charset="utf-8">
		<meta name="viewport" content="width=device-width, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0">
		<style>
			body {
				font-family: Monospace;
				background-color: #000;
				color: #fff;
				margin: 0px;
				overflow: hidden;
			}
			#info {
				color: #fff;
				position: absolute;
				top: 10px;
				width: 100%;
				text-align: center;
				z-index: 100;
				display:block;
			}
			#info a {
				color: #046;
				font-weight: bold;
			}
			canvas 
			{
				background:url("http://localhost/threejs/three.js-experiments/examples/models/fbx/bgimage.png";
				-webkit-background:url("http://localhost/threejs/three.js-experiments/examples/models/fbx/bgimage.png";
			}
		</style>
	</head>

	<body style="background:url('http://localhost/threejs/three.js-experiments/examples/models/fbx/bgimage.png')">
		
		<div>
			<form method="post" enctype='multipart/form-data' style="padding-left:100px">
				<input type="file" name="bgimg"/> OR URL <input type="url" name="imgUrl"/> (URL will take precedence if both given. Max file size 5mb)
				<br/>
				<input type="file" name="model"/> OR URL <input type="url" name="modelUrl"/> (URL will take precedence if both given. Max file size 5mb)
				<input type="submit" name="sbmt" />
			</form>
		</div>
		
		
		<div id="info"></div>
		
<?php
		if(isset($_POST['sbmt']))
		{
			
			
			if(!empty($_FILES['bgimg']['tmp_name']))
			{
				move_uploaded_file($_FILES['bgimg']['tmp_name'], "./models/fbx/".$_FILES['bgimg']['name']);
				$bgname = "./models/fbx/".$_FILES['bgimg']['name'];
			}
			else
			{
				//get the filename 
				$bgname = explode("/",$_POST['imgUrl']);
				$bgname = strip_tags($bgname[count($bgname)-1]);
				file_put_contents("./models/fbx/".$bgname,file_get_contents(strip_tags($_POST['imgUrl'])));
				$bgname = "./models/fbx/".$bgname;
			}
			
			if(!empty($_FILES['model']['tmp_name']))
			{
				move_uploaded_file($_FILES['model']['tmp_name'], "./models/fbx/".$_FILES['model']['name']);
				$model = "./models/fbx/".$_FILES['model']['name'];
			}
			else
			{
				//get the filename 
				$model = explode("/",$_POST['modelUrl']);
				$model = strip_tags($model[count($model)-1]);
				file_put_contents("./models/fbx/".$model,file_get_contents(strip_tags($_POST['modelUrl'])));
				$model = "./models/fbx/".$model;
			}
			
		}
		else
		{
			$model = "models/fbx/cube.fbx";
			$bgname = "http://localhost/threejs/three.js-experiments/examples/models/fbx/bgimage.png";
		}

?>


		

		<script src="../build/three.js"></script>

		<script src="js/libs/inflate.min.js"></script>
		<script src="js/loaders/FBXLoader.js"></script>

		<script src="js/controls/OrbitControls.js"></script>

		<script src="js/WebGL.js"></script>
		<script src="js/libs/stats.min.js"></script>
		<script src="files.js"></script>

		<script>

			if ( WEBGL.isWebGLAvailable() === false ) {

				document.body.appendChild( WEBGL.getWebGLErrorMessage() );

			}

			//var container, stats, controls;
			var renderer;
			var scenes = [];
			var mixers = [];
			
			init();
			animate();

			function init() {

				var container = document.createElement( 'div' );
				document.body.appendChild( container );
				
				var scene = new THREE.Scene();
				
				scene.userData.element = container;

				var camera = new THREE.PerspectiveCamera( 45, window.innerWidth / window.innerHeight, 1, 2000 );
				camera.position.set( -96, 357, 127 );
				scene.userData.camera = camera;

				var controls = new THREE.OrbitControls( scene.userData.camera, scene.userData.element );
				controls.target.set( 0, 100, 0 );
				scene.userData.controls = controls;
				controls.update();
				
				scene.background = new THREE.Color( 0xa0a0a0 );

				var light = new THREE.HemisphereLight( 0xffffbb, 0x080820, 1 );
				scene.add( light );
				
				// model
				var loader = new THREE.FBXLoader();
				loader.load( 
					'<?php echo $model ?>', 
					function( object )
					{
						scene.add( object );
					},
					function(){},
					function(){},
					function(e)
					{
						console.error(e);
					}
				);

				
				//scene two //models/fbx/bgimage.png   http://localhost/threejs/three.js-master/three.js-master/examples/models/fbx/bgimage.png
				loader = new THREE.TextureLoader();
				loader.setCrossOrigin("");
				bgTexture = loader.load("<?php echo $bgname ?>",
					function ( texture ) {
						var img = texture.image;
						bgWidth= img.width;
						bgHeight = img.height;
						resize();
					}
				);
				scene.background = bgTexture;
				
				scenes.push(scene);
				
				
				renderer = new THREE.WebGLRenderer({ alpha: true });
				renderer.setClearColor( 0xffffff, 0);
				renderer.setPixelRatio( window.devicePixelRatio );
				renderer.setSize( window.innerWidth, window.innerHeight );
				renderer.setClearColor( 0xffffff );
				renderer.autoClear = false;
				container.appendChild( renderer.domElement );

				window.addEventListener( 'resize', onWindowResize, false );

				// stats
				stats = new Stats();
				container.appendChild( stats.dom );

			}

			function onWindowResize() {

				camera.aspect = window.innerWidth / window.innerHeight;
				camera.updateProjectionMatrix();

				renderer.setSize( window.innerWidth, window.innerHeight );
				renderer.autoClear = false;

			}

			//

			function animate() {

				render();
				requestAnimationFrame( animate );
				stats.update();
			}
			
			function render()
			{				
				scenes.forEach( function ( scene ) {
					var camera = scene.userData.camera;
					renderer.clear();
					renderer.render( scene, camera );
				});
			}
			
		</script>

	</body>
</html>
